Attribute VB_Name = "mdCreateArcStartEndCenter"
'	This is a part of the source code for Pro/DESKTOP.
'	Copyright (C) 1999 Parametric Technology Corporation.
'	All rights reserved.


Rem Function to create an arc given its start point, end point and center point

Function CreateArcStartEndCenter(startpoint As APoint, endpoint As APoint, center As APoint)

Rem To get the global objects like application, part, workplane, sketch
GetApplicationObject

Dim Part As PartDocument
Set Part = app.GetActiveDoc

Dim sketch1 As ASketch
Set sketch1 = Part.GetActiveSketch

Dim wp As AWorkplane
Set wp = Part.GetActiveWorkplane

'To get the normal to Workplane
Dim normplane As ZPlane
Set normplane = wp.GetGeometry

Dim norm As ZDirection
Set norm = normplane.GetNormal

'To find the radius
Dim centervect As ZVector
Set centervect = center.GetPosition

Dim startvect As ZVector
Set startvect = startpoint.GetPosition

Dim endvect As ZVector
Set endvect = endpoint.GetPosition

Dim radiusvect As ZVector
Set radiusvect = centervect.Subtract(startvect)

Dim radius As Double
radius = radiusvect.GetMagnitude

Dim curve As ZCurve
Set curve = app.GetClass("BasicCircularArc").CreateBasicCircularArc(wp.Get3DVector(centervect), norm, radius, wp.Get3DVector(startvect), wp.Get3DVector(endvect))

Dim lineobj As ALine
Set lineobj = sketch1.CreateLine(curve)

wp.AutoConstrain lineobj

Set CreateArcStartEndCenter = lineobj

End Function



